

/*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Wed Jan 12 12:16:55 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief RSA external application ATP tests  
   *
   *  \version CRYS_Ext_ATP_RSA_Acceptance.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/***** Include Files ******/ 
#include "CRYS.h"
 
#include "CRYS_Ext_ATP_TST_Defines.h"
#include "CRYS_ATP_TST_UTIL_Funcs.h"
#include "CRYS_Ext_ATP_RSA_Acceptance.h"
#include "CRYS_Ext_ATP_RSA_Acceptance_test_vectors.h"
#include "CRYS_HOST_TST_RSA.h"

#include "DX_VOS_Mem.h"
#include "math.h"
#include <stdio.h>

/******** Defines ********/
/******** Enums **********/
/******** Typedefs *********/
/******** Global Data ********/
/***** Private function prototype ******/
/******** Private Functions ******/
extern char FailureFunctionNameOut[FailureFunctionName_K_Size];
/******** Public Functions *****/

/*****************************************************************************
* Function Name:                                                           
*  CRYS_Ext_ATP_RSA_Acceptance_PRIME_EncDec      
*  
* Inputs:
*  None
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for RSA primitive encrypt and decrypt function,
*  implemented as external SEP application  
*  This also outputs the results to an output buffer or the same input buffer.
*  Keys size used (in bits) - 2048                                                        
* Algorithm:       
* 1. Call the SEPQA_RSA_PRIME_EncDec function to execute test
* 2. Verify function succeded according to the returned error code
*
******************************************************************************/                                
CRYSError_t CRYS_Ext_ATP_RSA_PRIME_EncDec ( void )
{
    /*** TST Variables Definitions ****/
    int           TST_index = 0;
	int           TST_CRT_Mode;
    CRYSError_t   TST_TestStatus=0;
    char          TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_Ext_ATP_RSA_Acceptance_PRIME_EncDec";   
    
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*********************** \n"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"** CRYS_Ext_ATP_RSA_Acceptance_PRIME_EncDec Tests   ******* \n"));      
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*********************** \n\n"));
    
    /****************/
    /***** Start of test ********/
    /****************/
    for (TST_CRT_Mode = 0 ; TST_CRT_Mode < 2 ; TST_CRT_Mode++)/* TST_CRT_Mode = 0 no CRT // TST_CRT_Mode = 1 CRT mode*/
    {
        if (!((TST_CRT_Mode == TST_CRT_MODE) && 
              (SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize == TST_RSA_512_KEY_SIZE_IN_BYTES) &&
             ((TST_ATP_CRYS_version.LLF_PKI_Version.type != CRYS_DEFS_SW_ENGINE_TYPE))))
		{ 
			/* output buffer != input buffer    */
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"************************ \n"));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," %s[test 1.%d]\n",SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_Name,TST_index));  

            if (TST_CRT_Mode == TST_NO_CRT)
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," Non CRT mode  \n"));
            else
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," CRT mode  \n"));

            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"************************ \n"));

			TST_ATP_Error = SEPQA_RSA_PRIME_EncDec (
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_PublicExponent_E,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_PubExponentSize,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_PrivetExponent_D,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_Modulus_N,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize,
					TST_CRT_Mode,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_P,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_DPSize,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_Q,                                                                                                 
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_DPSize,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_dP,                                                                                                
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_DPSize, 
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_dQ,                                                                                                
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_DPSize,                                                                                                
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_Qinv,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_DPSize,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_input_data,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_Expected_output_data,
					FailureFunctionNameOut,
					FailureFunctionName_K_Size);

			TST_TestStatus = TST_ATP_CheckErrorReturn(TST_ATP_Error,"SEPQA_RSA_PRIME_EncDec",FailureFunctionNameOut,TST_MasterTestName);                   

			if (TST_TestStatus != TESTPASS) 
				goto End;	
		}/* End of CRT constraint*/
  }/*End of TST_CRT_Mode loop*/
End:
  return TST_TestStatus; 
}/*End of CRYS_ATP_TST_RSA_Acceptance_PRIME_EncDec*/



/*****************************************************/
/*TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************/
/*--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************/
/*TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************/
/*--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************/
/*****************************************************/


/*****************************************************************************
* Function Name:                                                           
*  CRYS_Ext_ATP_RSA_Acceptance_PRIME_SignVerify      
*  
* Inputs:
*  None
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  Description:                                                                 
*  This function Is a Acceptance test for RSA primitive Sign & Verify                  
*  This function signs and verifies known vectors using RSA primitives                                  ,
*  implemented as external SEP application  
*  This also outputs the results to an output buffer or the same input buffer.
*  Keys size used (in bits) - 2048                                                        
* Algorithm:       
* 1. Call the SEPQA_RSA_PRIME_SignVerify function to execute test
* 2. Verify function succeded according to the returned error code
*
******************************************************************************/                                
CRYSError_t CRYS_Ext_ATP_RSA_PRIME_SignVerify ( void )
{
    /*** TST Variables Definitions ****/
    int           TST_index = 0;
	int           TST_CRT_Mode;
    CRYSError_t   TST_TestStatus=0;
    char          TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_Ext_ATP_RSA_Acceptance_PRIME_SignVerify"; 
    
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*********************** \n"));
	ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"** CRYS_Ext_ATP_TST_RSA_Acceptance_PRIME_SignVerify ******* \n"));      
	ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*********************** \n \n"));

	/****************/
	/***** Start of test ********/
	/****************/
	for (TST_CRT_Mode = 0 ; TST_CRT_Mode < 2 ; TST_CRT_Mode++)/* TST_CRT_Mode = 0 no CRT // TST_CRT_Mode = 1 CRT mode*/
	{
	
			if (!((TST_CRT_Mode == TST_CRT_MODE) && 
				(SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize == TST_RSA_512_KEY_SIZE_IN_BYTES) &&
				((TST_ATP_CRYS_version.LLF_PKI_Version.type != CRYS_DEFS_SW_ENGINE_TYPE))))
			{ 
				/* output buffer != input buffer    */
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"************************ \n"));
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," %s[test 2.%d]\n",SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_Name,TST_index));  
				if (TST_CRT_Mode == TST_NO_CRT)
					ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," Non CRT mode  \n"));
				else
					ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," CRT mode  \n"));
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"************************ \n"));     

				TST_ATP_Error = SEPQA_RSA_PRIME_SignVerify (
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_PublicExponent_E,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_PubExponentSize,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_PrivetExponent_D,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_Modulus_N,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize,
					TST_CRT_Mode,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_P,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_DPSize,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_Q,                                                                                                 
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_DPSize,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_dP,                                                                                                
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_DPSize, 
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_dQ,                                                                                                
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_DPSize,                                                                                                
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_Qinv,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_DPSize,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_input_data,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_Expected_output_data,
					FailureFunctionNameOut,
					FailureFunctionName_K_Size);

				TST_TestStatus = TST_ATP_CheckErrorReturn(TST_ATP_Error,"SEPQA_RSA_PRIME_SignVerify",FailureFunctionNameOut,TST_MasterTestName);                   

				if (TST_TestStatus != TESTPASS) 
					goto End;	                                                        
			}/*End of CRT constarint*/
	}/*End of TST_CRT_Mode loop*/
     
 End:
  return TST_TestStatus; 
}/*End of CRYS_ATP_TST_RSA_Acceptance_PRIME_EncDec*/


/*****************************************************/
/*TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************/
/*--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************/
/*TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************/
/*--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************/
/*****************************************************/
/***************************
 * Function Name:                                                           
 *  CRYS_Ext_ATP_RSA_PKCS1v15_EncDec         
 * 
 * Inputs:
 * 	TST_KeyGeneration_TestStatus - A parameter defining if to run the test with internal key generation 
 *                                TST_INTERNAL_KG - Run the test with internal key generation and external keys 
 *                                TST_EXTERNAL_KEYPAIR  - Run the test with external key only - NO keyGen
 *
 * Outputs:
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for RSA PKCS1v15 encrypt and decrypt 
 *  according to PKCS#1 Ver1.5 implemented as external SEP application  
 *  This also outputs the results to an output buffer or the same input buffer.
 *  Keys size used (in bits) - 2048                                                        
 * Algorithm:       
 * 1. Call the SEPQA_RSA_PKCS1v15_EncDec function to execute test
 * 2. Verify function succeded according to the returned error code
 *
 **************************/                                
CRYSError_t CRYS_Ext_ATP_RSA_PKCS1v15_EncDec (int TST_KeyGeneration_TestStatus)
{
    /*** TST Variables Definitions ****/
    int         TST_index = 0;
	int			TST_CRT_Mode,TST_KeyGenType;
    CRYSError_t TST_TestStatus=0;
    char        TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_Ext_ATP_RSA_PKCS1v15_EncDec";  
    

    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*********************** \n"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"** CRYS_Ext_ATP_RSA_PKCS1v15_EncDec Tests   ******* \n"));       
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*********************** \n \n"));
    
    /****************/
    /***** Start of test ********/
    /****************/
    /* Setting if to use internal key generation */
    if (TST_KeyGeneration_TestStatus == TST_NO_INTERNAL_KEYGEN)
        TST_KeyGenType = TST_EXTERNAL_KEYPAIR;
    else
        TST_KeyGenType = TST_INTERNAL_KG;

    for ( ; TST_KeyGenType <2 ; TST_KeyGenType++)/*TST_KeyGenType = 0 Internal KeyGen // TST_KeyGenType = 1 External keys*/
    {   
        for (TST_CRT_Mode = 0 ; TST_CRT_Mode < 2 ; TST_CRT_Mode++)/* TST_CRT_Mode = 0 no CRT // TST_CRT_Mode = 1 CRT mode*/
        {   
            if (!((TST_CRT_Mode == TST_CRT_MODE) && 
                 (SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize == TST_RSA_512_KEY_SIZE_IN_BYTES) &&
                 ((TST_ATP_CRYS_version.LLF_PKI_Version.type != CRYS_DEFS_SW_ENGINE_TYPE))))
			{ 
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"************************ \n"));
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," %s[test 3.%d]\n",SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_Name,TST_index));  
				if (TST_CRT_Mode == TST_NO_CRT)
					ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," Non CRT mode  \n"));
				else
					ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," CRT mode  \n"));
				if (TST_KeyGenType == TST_INTERNAL_KG)
					ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," Internal Key Generation  \n"));
				else
					ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," External Keys  \n"));                        
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"************************ \n"));


				TST_ATP_Error = SEPQA_RSA_PKCS1v15_EncDec (
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_PublicExponent_E,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_PubExponentSize,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_PrivetExponent_D,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_Modulus_N,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize,
					TST_KeyGenType,
					TST_CRT_Mode,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_P,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_DPSize,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_Q,                                                                                                 
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_DPSize,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_dP,                                                                                                
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_DPSize, 
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_dQ,                                                                                                
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_DPSize,                                                                                                
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_Qinv,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_DPSize,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_input_data,
					(DxUint16_t)(SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize-TST_LESS_DATA_FOR_PKCS1V15_ENCRYPT),
					FailureFunctionNameOut,
					FailureFunctionName_K_Size);
										
				TST_TestStatus = TST_ATP_CheckErrorReturn(TST_ATP_Error,"SEPQA_RSA_PKCS1v15_EncDec",FailureFunctionNameOut,TST_MasterTestName);                   

				if (TST_TestStatus != TESTPASS) 
					goto End;						
			}/* End of CRT constarint */
		}/*End of TST_CRT_Mode loop*/
     }/*End of TST_KeyGenType loop*/
End:
  return TST_TestStatus; 
}/*End of CRYS_ATP_TST_RSA_Acceptance_PKCS1v15_EncDec*/


				
/*****************************************************/
/*TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************/
/*--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************/
/*TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************/
/*--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************/
/*****************************************************/
/***************************
 * Function Name:                                                           
 *  CRYS_Ext_ATP_RSA_PKCS1v15_NonIntegrate_SignVerify        
 * 
 * Inputs:
 * 	TST_KeyGeneration_TestStatus - A parameter defining if to run the test with internal key generation 
 *                                TST_INTERNAL_KG - Run the test with internal key generation and external keys 
 *                                TST_EXTERNAL_KEYPAIR  - Run the test with external key only - NO keyGen
 *
 * Outputs:
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for RSA PKCS1v15 Sign & Verify 
 *  implemented as external SEP application  
 * Vectors sizes used (in byte) - 1536                                                       
 *  Key sizes used     (in bits) - 2048
 * Algorithm:       
 * 1. Call the SEPQA_RSA_PKCS1v15_NonIntegrate_SignVerify function to execute test
 * 2. Verify function succeded according to the returned error code
 *
 **************************/
CRYSError_t CRYS_Ext_ATP_RSA_PKCS1v15_NonIntegrate_SignVerify (int TST_KeyGeneration_TestStatus)
{
    /*** TST Variables Definitions ****/
    int							TST_index = 0;
	int							TST_CRT_Mode;
    CRYSError_t					TST_TestStatus=0;
    int							TST_KeyGenType;
    char						TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_Ext_ATP_RSA_PKCS1v15_NonIntegrate_SignVerify";   
    CRYS_RSA_HASH_OpMode_t		TST_RSAHashType=CRYS_RSA_HASH_SHA1_mode;

    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*********************** \n"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"** CRYS_Ext_ATP_RSA_PKCS1v15_NonIntegrate_SignVerify Tests  ** \n"));      
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*********************** \n \n"));
    
    /****************/
    /***** Start of test ********/
    /****************/
    /* Setting if to use internal key generation */
    if (TST_KeyGeneration_TestStatus == TST_NO_INTERNAL_KEYGEN)
        TST_KeyGenType = TST_EXTERNAL_KEYPAIR;
    else
        TST_KeyGenType = TST_INTERNAL_KG;

    for ( ; TST_KeyGenType <2 ; TST_KeyGenType++)/*TST_KeyGenType = 0 Internal KeyGen // TST_KeyGenType = 1 External keys*/
    {   
		for (TST_CRT_Mode = 0 ; TST_CRT_Mode < 2 ; TST_CRT_Mode++)/* TST_CRT_Mode = 0 no CRT // TST_CRT_Mode = 1 CRT mode*/
		{   
			/* CRT constraint CRT with 512 key dose not work on other then SW platfrom*/
			if (((TST_CRT_Mode == TST_CRT_MODE) && 
                (SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize == TST_RSA_512_KEY_SIZE_IN_BYTES) &&
                ((TST_ATP_CRYS_version.LLF_PKI_Version.type != CRYS_DEFS_SW_ENGINE_TYPE))))
				continue;

			/* SHA384 & SHA512 are not used with RSA 512bit keys*/
			if ((SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize == TST_RSA_512_KEY_SIZE_IN_BYTES)&&
                ((TST_RSAHashType == CRYS_RSA_HASH_SHA384_mode)||(TST_RSAHashType == CRYS_RSA_HASH_SHA512_mode)))
				continue;

			ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"************************ \n"));
			ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," %s[test 4.%d]\n",SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Name,TST_index)); 
			CRYS_ATP_TST_PrintHASHType(CRYS_HASH_SHA1_mode);              
			if (TST_CRT_Mode == TST_NO_CRT)
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," Non CRT mode  \n"));
			else
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," CRT mode  \n"));
			if (TST_KeyGenType == TST_INTERNAL_KG)
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," Internal Key Generation  \n"));
			else
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," External Keys  \n"));                        
			ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"************************ \n"));

			TST_ATP_Error = SEPQA_RSA_PKCS1v15_NonIntegrate_SignVerify(
				SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_PublicExponent_E,
				SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_PubExponentSize,
				SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_PrivetExponent_D,
				SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize,
				SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Modulus_N,
				SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize,
				TST_CRT_Mode,
				TST_KeyGenType,
				TST_RSAHashType,
				SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_P,
				SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_DPSize,
				SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Q,                                                                                                
				SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_DPSize,
				SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_dP,                                                                                                   
				SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_DPSize,    
				SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_dQ,                                                                                                   
				SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_DPSize,                                                                                                   
				SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Qinv,
				SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_DPSize,
				SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_input_data,
				SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_input_dataSize,
				FailureFunctionNameOut,
				FailureFunctionName_K_Size);

			TST_TestStatus = TST_ATP_CheckErrorReturn(TST_ATP_Error,"SEPQA_RSA_PKCS1v15_NonIntegrate_SignVerify",FailureFunctionNameOut,TST_MasterTestName);                   

			if (TST_TestStatus != TESTPASS) 
				goto End;						
		}/*End of TST_CRT_Mode loop*/
       
    }/*End of TST_KeyGenType loop*/
End:
	return TST_TestStatus; 
}/*End of CRYS_ATP_TST_RSA_Acceptance_PKCS1v15_NonIntegrate_SignVerify*/



/*****************************************************/
/*TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************/
/*--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************/
/*TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************/
/*--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************/
/*****************************************************/
/***************************
 * Function Name:                                                           
 *  CRYS_Ext_ATP_RSA_PKCS1v15_Integrated_SignVerify      
 * 
 * Inputs:
 * 	TST_KeyGeneration_TestStatus - A parameter defining if to run the test with internal key generation 
 *                                TST_INTERNAL_KG - Run the test with internal key generation and external keys 
 *                                TST_EXTERNAL_KEYPAIR  - Run the test with external key only - NO keyGen
 *
 * Outputs:
 *  CRYSError_t - Function error return                                     
 * Description:                                                                 
 *  This function Is a Acceptance test for RSA PKCS1v15 Sign & Verify
 *  implemented as external SEP application  
 * Vectors sizes used (in byte) - 1536                                                       
 *  Key sizes used     (in bits) - 2048
 * Algorithm:       
 * 1. Call the SEPQA_RSA_PKCS1v15_Integrate_SignVerify function to execute test
 * 2. Verify function succeded according to the returned error code
 *
 **************************/
CRYSError_t CRYS_Ext_ATP_RSA_PKCS1v15_Integrated_SignVerify (int TST_KeyGeneration_TestStatus)
{
    /*** TST Variables Definitions ****/
    int         TST_index = 0;
	int         TST_CRT_Mode;
    CRYSError_t TST_TestStatus=0;
    int         TST_KeyGenType;
    char        TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_Ext_ATP_RSA_PKCS1v15_Integrated_SignVerify"; 
    int 				   TST_HashType = CRYS_HASH_SHA1_mode;
    CRYS_RSA_HASH_OpMode_t TST_RSAHashType=CRYS_RSA_HASH_SHA1_mode;

    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*********************** \n"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"** CRYS_Ext_ATP_RSA_PKCS1v15_Integrated_SignVerify Tests    ** \n"));      
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*********************** \n \n"));
    
    /****************/
    /***** Start of test ********/
    /****************/
    /* Setting if to use internal key generation */
    if (TST_KeyGeneration_TestStatus == TST_NO_INTERNAL_KEYGEN)
        TST_KeyGenType = TST_EXTERNAL_KEYPAIR;
    else
        TST_KeyGenType = TST_INTERNAL_KG;

    for ( ; TST_KeyGenType <2 ; TST_KeyGenType++)/*TST_KeyGenType = 0 Internal KeyGen // TST_KeyGenType = 1 External keys*/
    {   
		for (TST_CRT_Mode = 0 ; TST_CRT_Mode < 2 ; TST_CRT_Mode++)/* TST_CRT_Mode = 0 no CRT // TST_CRT_Mode = 1 CRT mode*/
		{   
        
			/* CRT constraint CRT with 512 key dose not work on other then SW platfrom*/
            if (((TST_CRT_Mode == TST_CRT_MODE) && 
                (SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize == TST_RSA_512_KEY_SIZE_IN_BYTES) &&
                ((TST_ATP_CRYS_version.LLF_PKI_Version.type != CRYS_DEFS_SW_ENGINE_TYPE))))
            continue;
            /* SHA384 & SHA512 are not used with RSA 512bit keys*/
            if ((SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize == TST_RSA_512_KEY_SIZE_IN_BYTES)&&
                ((TST_RSAHashType == CRYS_RSA_HASH_SHA384_mode)||(TST_RSAHashType == CRYS_RSA_HASH_SHA512_mode)))
            continue;

			ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"************************ \n"));
			ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," %s[test 5.%d]\n",SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Name,TST_index)); 
			CRYS_ATP_TST_PrintHASHType((CRYS_HASH_OperationMode_t)TST_HashType);                
			if (TST_CRT_Mode == TST_NO_CRT)
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," Non CRT mode  \n"));
			else
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," CRT mode  \n"));
			if (TST_KeyGenType == TST_INTERNAL_KG)
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," Internal Key Generation  \n"));
			else
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," External Keys  \n"));                                
			ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"************************ \n"));

			TST_ATP_Error = SEPQA_RSA_PKCS1v15_Integrate_SignVerify(
				SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_PublicExponent_E,
				SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_PubExponentSize,
				SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_PrivetExponent_D,
				SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize,
				SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Modulus_N,
				SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize,
				TST_CRT_Mode,
				TST_KeyGenType,
				TST_RSAHashType,
				SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_P,
				SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_DPSize,
				SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Q,                                                                                                
				SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_DPSize,
				SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_dP,                                                                                                   
				SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_DPSize,    
				SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_dQ,                                                                                                   
				SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_DPSize,                                                                                                   
				SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Qinv,
				SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_DPSize,
				SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_input_data,
				SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_input_dataSize,
				FailureFunctionNameOut,
				FailureFunctionName_K_Size);

			TST_TestStatus = TST_ATP_CheckErrorReturn(TST_ATP_Error,"SEPQA_RSA_PKCS1v15_Integrate_SignVerify",FailureFunctionNameOut,TST_MasterTestName);                   

			if (TST_TestStatus != TESTPASS) 
				goto End;						
		}/*End of TST_CRT_Mode loop*/

	}/*End of TST_KeyGenType loop*/
End:
	return TST_TestStatus; 
}/*End of CRYS_ATP_TST_RSA_Acceptance_PKCS1v15_Integrated_SignVerify*/
/*****************************************************/
/*TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************/
/*--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************/
/*TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************/
/*--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************/
/*****************************************************/
/***************************
 * Function Name:                                                           
 *  CRYS_Ext_ATP_RSA_OAEP_EncDec         
 * 
 * Inputs:
 * 	TST_KeyGeneration_TestStatus - A parameter defining if to run the test with internal key generation 
 *                                TST_INTERNAL_KG - Run the test with internal key generation and external keys 
 *                                TST_EXTERNAL_KEYPAIR  - Run the test with external key only - NO keyGen
 *
 * Outputs:
 *  CRYSError_t - Function error return                                     
 * Description:                                                                 
 *  This function Is a Acceptance test for RSA OAEP encrypt and decrypt
 *  according to PKCS#1 Ver2.1 implemented as external SEP application  
 * Vectors sizes used (in byte) - 1536                                                       
 *  Key sizes used     (in bits) - 2048
 * Algorithm:       
 * 1. Call the SEPQA_RSA_OAEP_EncDec function to execute test
 * 2. Verify function succeded according to the returned error code
 *
 **************************/                                
CRYSError_t CRYS_Ext_ATP_RSA_OAEP_EncDec (int TST_KeyGeneration_TestStatus)
{
    /*** TST Variables Definitions ****/
    int           TST_index = 0;
	int           TST_CRT_Mode;
    CRYSError_t   TST_TestStatus=0;
    int           TST_KeyGenType;
    char          TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_ATP_TST_RSA_Acceptance_OAEP_EncDec";  
    int						  TST_HashType = CRYS_HASH_SHA256_mode;
    CRYS_RSA_HASH_OpMode_t    TST_RSAHashType=CRYS_RSA_HASH_SHA256_mode;

	DxUint16_t    TST_LessDataForOAEP = (DxUint16_t)TST_LESS_DATA_FOR_OAEP_ENCRYPT_SHA256;
    
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*********************** \n"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"** CRYS_Ext_ATP_RSA_OAEP_EncDec Tests   ******* \n"));       
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*********************** \n \n"));
    
    /****************/
    /***** Start of test ********/
    /****************/
    /* Setting if to use internal key generation */
    if (TST_KeyGeneration_TestStatus == TST_NO_INTERNAL_KEYGEN)
        TST_KeyGenType = TST_EXTERNAL_KEYPAIR;
    else
        TST_KeyGenType = TST_INTERNAL_KG;

    for ( ; TST_KeyGenType <2 ; TST_KeyGenType++)/*TST_KeyGenType = 0 Internal KeyGen // TST_KeyGenType = 1 External keys*/
    {      
		if (TST_HashType != CRYS_HASH_MD5_mode) /* MD5 is not a part of the OAEP scheme*/
		{
			for (TST_CRT_Mode = 0 ; TST_CRT_Mode < 2 ; TST_CRT_Mode++)/* TST_CRT_Mode = 0 no CRT // TST_CRT_Mode = 1 CRT mode*/
			{   
				/* CRT constraint CRT with 512 key dose not work on other then SW platfrom*/
                if (((TST_CRT_Mode == TST_CRT_MODE) && 
                    (SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize == TST_RSA_512_KEY_SIZE_IN_BYTES) &&
                    ((TST_ATP_CRYS_version.LLF_PKI_Version.type != CRYS_DEFS_SW_ENGINE_TYPE))))
                    continue;
                /* SHA256 & SHA384 & SHA512 are not used with RSA 512bit keys in OAEP*/
                if ((SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize == TST_RSA_512_KEY_SIZE_IN_BYTES)&&
                    ((TST_RSAHashType == CRYS_RSA_HASH_SHA256_mode)||(TST_RSAHashType == CRYS_RSA_HASH_SHA384_mode)||(TST_RSAHashType == CRYS_RSA_HASH_SHA512_mode)))
                    continue;

				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"************************ \n"));
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," %s[test 7.%d]\n",SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_Name,TST_index));  
				if (TST_CRT_Mode == TST_NO_CRT)
					ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," Non CRT mode  \n"));
				else
					ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," CRT mode  \n"));
				if (TST_KeyGenType == TST_INTERNAL_KG)
					ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," Internal Key Generation  \n"));
				else
					ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," External Keys  \n")); 
				CRYS_ATP_TST_PrintHASHType((CRYS_HASH_OperationMode_t)TST_HashType);
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"************************ \n"));

				TST_ATP_Error = SEPQA_RSA_OAEP_EncDec(
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_PublicExponent_E,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_PubExponentSize,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_PrivetExponent_D,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_Modulus_N,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize,
					TST_CRT_Mode,
					TST_KeyGenType,
					TST_RSAHashType,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_P,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_DPSize,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_Q,                                                                                                
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_DPSize,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_dP,                                                                                                   
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_DPSize,    
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_dQ,                                                                                                   
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_DPSize,                                                                                                   
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_Qinv,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_DPSize,
					SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_input_data,
					(DxUint16_t)(SEP_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize-TST_LessDataForOAEP),
					FailureFunctionNameOut,
					FailureFunctionName_K_Size);

				TST_TestStatus = TST_ATP_CheckErrorReturn(TST_ATP_Error,"SEPQA_RSA_OAEP_EncDec",FailureFunctionNameOut,TST_MasterTestName);                   

				if (TST_TestStatus != TESTPASS) 
					goto End;						
            }/*End of TST_CRT_Mode loop*/
        }/*End of MD5 if*/
	}/*End of TST_KeyGenType loop*/    
End:
	return TST_TestStatus; 
}/*End of CRYS_Ext_ATP_RSA_OAEP_EncDec*/


/*****************************************************/
/*TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************/
/*--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************/
/*TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************/
/*--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************/
/*****************************************************/
/***************************
 * Function Name:                                                           
 *  CRYS_Ext_ATP_RSA_PSS_NonIntegrate_SignVerify         
 * 
 * Inputs:
 * 	TST_KeyGeneration_TestStatus - A parameter defining if to run the test with internal key generation 
 *                                TST_INTERNAL_KG - Run the test with internal key generation and external keys 
 *                                TST_EXTERNAL_KEYPAIR  - Run the test with external key only - NO keyGen
 *
 * Outputs:
 *  CRYSError_t - Function error return                                     
 * Description:                                                                 
 *  This function Is a Acceptance test for RSA PSS PKCS#1v2.1 sign & Verify
 * Vectors sizes used (in byte) - 1536                                                       
 *  Key sizes used     (in bits) - 2048
 * Algorithm:       
 * 1. Call the SEPQA_RSA_PSS_NonIntegrate_SignVerify function to execute test
 * 2. Verify function succeded according to the returned error code
 *
 **************************/                                
CRYSError_t CRYS_Ext_ATP_RSA_PSS_NonIntegrate_SignVerify (int TST_KeyGeneration_TestStatus)
{
    /*** TST Variables Definitions ****/
    int         TST_index = 0;
	int         TST_CRT_Mode;
    CRYSError_t TST_TestStatus=0;
    int         TST_KeyGenType;
    char        TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_Ext_ATP_RSA_PSS_NonIntegrate_SignVerify";    
    int 	    TST_HashType = CRYS_HASH_SHA224_mode;
    CRYS_RSA_HASH_OpMode_t    TST_RSAHashType=CRYS_RSA_HASH_SHA224_mode;
    
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*********************** \n"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"** CRYS_Ext_ATP_RSA_PSS_NonIntegrate_SignVerify Tests  *** \n"));      
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*********************** \n \n"));
    
    /****************/
    /***** Start of test ********/
    /****************/
    /* Setting if to use internal key generation */
    if (TST_KeyGeneration_TestStatus == TST_NO_INTERNAL_KEYGEN)
        TST_KeyGenType = TST_EXTERNAL_KEYPAIR;
    else
        TST_KeyGenType = TST_INTERNAL_KG;

    for ( ; TST_KeyGenType <2 ; TST_KeyGenType++)/*TST_KeyGenType = 0 Internal KeyGen // TST_KeyGenType = 1 External keys*/
    {   
        if (TST_HashType != CRYS_HASH_MD5_mode) /* MD5 is not a part of the OAEP scheme*/
		{
			for (TST_CRT_Mode = 0 ; TST_CRT_Mode < 2 ; TST_CRT_Mode++)/* TST_CRT_Mode = 0 no CRT // TST_CRT_Mode = 1 CRT mode*/
            {   
				/* CRT constraint CRT with 512 key dose not work on other then SW platfrom*/
                if (((TST_CRT_Mode == TST_CRT_MODE) && 
                        (SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize == TST_RSA_512_KEY_SIZE_IN_BYTES) &&
                        ((TST_ATP_CRYS_version.LLF_PKI_Version.type != CRYS_DEFS_SW_ENGINE_TYPE))))
                    continue;
                /* SHA384 & SHA512 are not used with RSA 512bit keys*/
                if ((SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize == TST_RSA_512_KEY_SIZE_IN_BYTES)&&
                    ((TST_RSAHashType == CRYS_RSA_HASH_SHA384_mode)||(TST_RSAHashType == CRYS_RSA_HASH_SHA512_mode)))
                    continue;

				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"************************ \n"));
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," %s[test 8.%d]\n",SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Name,TST_index)); 
				if (TST_CRT_Mode == TST_NO_CRT)
					ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," Non CRT mode  \n"));
				else
					ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," CRT mode  \n"));
				if (TST_KeyGenType == TST_INTERNAL_KG)
					ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," Internal Key Generation  \n"));
				else
					ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," External Keys  \n"));  
				CRYS_ATP_TST_PrintHASHType((CRYS_HASH_OperationMode_t)TST_HashType);
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"************************ \n"));

				TST_ATP_Error = SEPQA_RSA_PSS_NonIntegrate_SignVerify(
					SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_PublicExponent_E,
					SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_PubExponentSize,
					SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_PrivetExponent_D,
					SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize,
					SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Modulus_N,
					SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize,
					TST_CRT_Mode,
					TST_KeyGenType,
					TST_RSAHashType,
					SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_SaltLength,
					SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_P,
					SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_DPSize,
					SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Q,                                                                                                
					SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_DPSize,
					SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_dP,                                                                                                   
					SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_DPSize,    
					SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_dQ,                                                                                                   
					SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_DPSize,                                                                                                   
					SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Qinv,
					SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_DPSize,
					SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_input_data,
					SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_input_dataSize,
					FailureFunctionNameOut,
					FailureFunctionName_K_Size);

				TST_TestStatus = TST_ATP_CheckErrorReturn(TST_ATP_Error,"SEPQA_RSA_PSS_NonIntegrate_SignVerify",FailureFunctionNameOut,TST_MasterTestName);                   

				if (TST_TestStatus != TESTPASS) 
					goto End;						
			}/*End of TST_CRT_Mode loop*/
		}/*End of MD5 if*/
	}/*End of TST_KeyGenType loop*/    
                        
End: 
  return TST_TestStatus; 
}/*End of CRYS_ATP_TST_RSA_Acceptance_PSS_NonIntegrate_SignVerify*/
/*****************************************************/
/*TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************/
/*--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************/
/*TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************/
/*--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************/
/*****************************************************/
/***************************
 * Function Name:                                                           
 *  CRYS_Ext_ATP_RSA_PSS_Integrated_SignVerify       
 * 
 * Inputs:
 * 	TST_KeyGeneration_TestStatus - A parameter defining if to run the test with internal key generation 
 *                                TST_INTERNAL_KG - Run the test with internal key generation and external keys 
 *                                TST_EXTERNAL_KEYPAIR  - Run the test with external key only - NO keyGen
 *
 * Outputs:
 *  CRYSError_t - Function error return                                     
 * Description:                                                                 
 *  This function Is a Acceptance test for RSA PSS PKCS#1v2.1 sign & Verify
 * Vectors sizes used (in byte) - 1536                                                       
 *  Key sizes used     (in bits) - 2048
 * Algorithm:       
 * 1. Call the SEPQA_RSA_PSS_Integrate_SignVerify function to execute test
 * 2. Verify function succeded according to the returned error code
 *
 **************************/                                
CRYSError_t CRYS_Ext_ATP_RSA_PSS_Integrated_SignVerify (int TST_KeyGeneration_TestStatus)
{
	/*** TST Variables Definitions ****/
	int         TST_index = 0;
	int         TST_CRT_Mode;
	CRYSError_t TST_TestStatus=0;
	int         TST_KeyGenType;
	char        TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_Ext_ATP_RSA_PSS_Integrated_SignVerify";    
	int 	    TST_HashType = CRYS_HASH_SHA224_mode;
	CRYS_RSA_HASH_OpMode_t    TST_RSAHashType=CRYS_RSA_HASH_SHA224_mode;

	ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*********************** \n"));
	ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"** CRYS_Ext_ATP_RSA_PSS_Integrated_SignVerify Tests  *** \n"));      
	ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*********************** \n \n"));

	/****************/
	/***** Start of test ********/
	/****************/
	/* Setting if to use internal key generation */
	if (TST_KeyGeneration_TestStatus == TST_NO_INTERNAL_KEYGEN)
		TST_KeyGenType = TST_EXTERNAL_KEYPAIR;
	else
		TST_KeyGenType = TST_INTERNAL_KG;

	for ( ; TST_KeyGenType <2 ; TST_KeyGenType++)/*TST_KeyGenType = 0 Internal KeyGen // TST_KeyGenType = 1 External keys*/
	{   
		if (TST_HashType != CRYS_HASH_MD5_mode) /* MD5 is not a part of the OAEP scheme*/
		{
			for (TST_CRT_Mode = 0 ; TST_CRT_Mode < 2 ; TST_CRT_Mode++)/* TST_CRT_Mode = 0 no CRT // TST_CRT_Mode = 1 CRT mode*/
			{   
				/* CRT constraint CRT with 512 key dose not work on other then SW platfrom*/
				if (((TST_CRT_Mode == TST_CRT_MODE) && 
					(SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize == TST_RSA_512_KEY_SIZE_IN_BYTES) &&
					((TST_ATP_CRYS_version.LLF_PKI_Version.type != CRYS_DEFS_SW_ENGINE_TYPE))))
					continue;
				/* SHA384 & SHA512 are not used with RSA 512bit keys*/
				if ((SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize == TST_RSA_512_KEY_SIZE_IN_BYTES)&&
					((TST_RSAHashType == CRYS_RSA_HASH_SHA384_mode)||(TST_RSAHashType == CRYS_RSA_HASH_SHA512_mode)))
					continue;

				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"************************ \n"));
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," %s[test 8.%d]\n",SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Name,TST_index)); 
				if (TST_CRT_Mode == TST_NO_CRT)
					ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," Non CRT mode  \n"));
				else
					ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," CRT mode  \n"));
				if (TST_KeyGenType == TST_INTERNAL_KG)
					ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," Internal Key Generation  \n"));
				else
					ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," External Keys  \n"));  
				CRYS_ATP_TST_PrintHASHType((CRYS_HASH_OperationMode_t)TST_HashType);
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"************************ \n"));

				TST_ATP_Error = SEPQA_RSA_PSS_Integrate_SignVerify(
					SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_PublicExponent_E,
					SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_PubExponentSize,
					SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_PrivetExponent_D,
					SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize,
					SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Modulus_N,
					SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize,
					TST_CRT_Mode,
					TST_KeyGenType,
					TST_RSAHashType,
					SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_SaltLength,
					SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_P,
					SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_DPSize,
					SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Q,                                                                                                
					SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_DPSize,
					SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_dP,                                                                                                   
					SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_DPSize,    
					SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_dQ,                                                                                                   
					SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_DPSize,                                                                                                   
					SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Qinv,
					SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_DPSize,
					SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_input_data,
					SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_input_dataSize,
					FailureFunctionNameOut,
					FailureFunctionName_K_Size);

				TST_TestStatus = TST_ATP_CheckErrorReturn(TST_ATP_Error,"SEPQA_RSA_PSS_Integrate_SignVerify",FailureFunctionNameOut,TST_MasterTestName);                   

				if (TST_TestStatus != TESTPASS) 
					goto End;						
			}/*End of TST_CRT_Mode loop*/
		}/*End of MD5 if*/
	}/*End of TST_KeyGenType loop*/    

End: 
	return TST_TestStatus; 
}/*End of CRYS_ATP_TST_RSA_Acceptance_PSS_NonIntegrate_SignVerify*/
/*****************************************************/
/*TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************/
/*--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************/
/*TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************/
/*--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************/
/*****************************************************/

/***************************
 * Function Name:                                                           
 *  CRYS_Ext_ATP_RSA_PKCS1v15_ExternalHash_SignVerify        
 * 
 * Inputs:
 * 	TST_KeyGeneration_TestStatus - A parameter defining if to run the test with internal key generation 
 *                                TST_INTERNAL_KG - Run the test with internal key generation and external keys 
 *                                TST_EXTERNAL_KEYPAIR  - Run the test with external key only - NO keyGen
 *
 * Outputs:
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for RSA PKCS1v15 Sign & Verify
 *  When the Hash for the Sign is preformed externally                   
 *  This function Signs & Verifies hash vectors using RSA PKCS1v15
 *  Vectors sizes used (in byte) - SHA1 - 20, MD5 - 16                                                      
 *  Key sizes used     (in bits) - 2048
 * Algorithm:                       
 * 1. Call the SEPQA_RSA_PKCS1v15_ExternalHash_SignVerify function to execute test
 * 2. Verify function succeded according to the returned error code               
 *
 **************************/

CRYSError_t CRYS_Ext_ATP_RSA_PKCS1v15_ExternalHash_SignVerify (int TST_KeyGeneration_TestStatus)
{
	/*** TST Variables Definitions ****/
	int         TST_index = 0, TST_CRT_Mode;
	CRYSError_t TST_TestStatus=0;
	int         TST_HashType, TST_KeyGenType;
	char        TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_Ext_ATP_RSA_Acceptance_PKCS1v15_ExternalHash_SignVerify";       
    DxUint8_t*  TST_DataIn = DX_NULL;
	DxUint32_t  TST_DataInSize = 0;

	ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*********************** \n"));
	ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"** CRYS_Ext_ATP_RSA_Acceptance_PKCS1v15_ExternalHash_SignVerify Tests  ** \n"));      
	ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*********************** \n \n"));

	/****************/
	/***** Start of test ********/
	/****************/
	/* Setting if to use internal key generation */
	if (TST_KeyGeneration_TestStatus == TST_NO_INTERNAL_KEYGEN)
		TST_KeyGenType = TST_EXTERNAL_KEYPAIR;
	else
		TST_KeyGenType = TST_INTERNAL_KG;

	for ( ; TST_KeyGenType <2 ; TST_KeyGenType++)/*TST_KeyGenType = 0 Internal KeyGen // TST_KeyGenType = 1 External keys*/
	{       
		for (TST_HashType = 0 ; TST_HashType < CRYS_HASH_NumOfModes ; TST_HashType++) 
		{
			for (TST_CRT_Mode = 0 ; TST_CRT_Mode < 2 ; TST_CRT_Mode++)/* TST_CRT_Mode = 0 no CRT // TST_CRT_Mode = 1 CRT mode*/
			{   

				/* CRT constraint CRT with 512 key dose not work on other then SW platfrom*/
				if (((TST_CRT_Mode == TST_CRT_MODE) && 
					(SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize == TST_RSA_512_KEY_SIZE_IN_BYTES) &&
					((TST_ATP_CRYS_version.LLF_PKI_Version.type != CRYS_DEFS_SW_ENGINE_TYPE))))
					continue;
				/* SHA384 & SHA512 are not used with RSA 512bit keys*/
				if ((SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize == TST_RSA_512_KEY_SIZE_IN_BYTES)&&
					((TST_HashType == CRYS_HASH_SHA384_mode)||(TST_HashType == CRYS_HASH_SHA512_mode)))
					continue;


				/* output buffer != input buffer    */
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"************************ \n"));
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," %s[test 6.%d]\n",SEP_RSA_Acceptance_ExtHashSignVerify_TestData[TST_index].TST_Name,TST_index));  
				CRYS_ATP_TST_PrintHASHType((CRYS_HASH_OperationMode_t)TST_HashType);
				if (TST_CRT_Mode == TST_NO_CRT)
					ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," Non CRT mode  \n"));
				else
					ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," CRT mode  \n"));
				if (TST_KeyGenType == TST_INTERNAL_KG)
					ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," Internal Key Generation  \n"));
				else
					ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," External Keys  \n"));                            
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"************************ \n"));


				switch(TST_HashType)
				{
				case CRYS_HASH_SHA1_mode:
					TST_DataIn = SEP_RSA_Acceptance_ExtHashSignVerify_TestData[TST_index].TST_input_hash_SHA1;
                    TST_DataInSize = CRYS_HASH_SHA1_DIGEST_SIZE_IN_BYTES;
					break;
				case CRYS_HASH_SHA224_mode:
					TST_DataIn = SEP_RSA_Acceptance_ExtHashSignVerify_TestData[TST_index].TST_input_hash_SHA224;
					TST_DataInSize = CRYS_HASH_SHA224_DIGEST_SIZE_IN_BYTES;
					break;
				case CRYS_HASH_SHA256_mode:
					TST_DataIn = SEP_RSA_Acceptance_ExtHashSignVerify_TestData[TST_index].TST_input_hash_SHA256;
					TST_DataInSize = CRYS_HASH_SHA256_DIGEST_SIZE_IN_BYTES;
					break;
				case CRYS_HASH_SHA384_mode:
					TST_DataIn = SEP_RSA_Acceptance_ExtHashSignVerify_TestData[TST_index].TST_input_hash_SHA384;
					TST_DataInSize = CRYS_HASH_SHA384_DIGEST_SIZE_IN_BYTES;
					break;
				case CRYS_HASH_SHA512_mode:
					TST_DataIn = SEP_RSA_Acceptance_ExtHashSignVerify_TestData[TST_index].TST_input_hash_SHA512;
					TST_DataInSize = CRYS_HASH_SHA512_DIGEST_SIZE_IN_BYTES;
					break;
				case CRYS_HASH_MD5_mode:  
					TST_DataIn = SEP_RSA_Acceptance_ExtHashSignVerify_TestData[TST_index].TST_input_hash_MD5;
					TST_DataInSize = CRYS_HASH_MD5_DIGEST_SIZE_IN_BYTES;
					break;
				default:
					break;
				}     

				SEPQA_RSA_PKCS1v15_ExternalHash_SignVerify(
					SEP_RSA_Acceptance_ExtHashSignVerify_TestData[TST_index].TST_PublicExponent_E,
					SEP_RSA_Acceptance_ExtHashSignVerify_TestData[TST_index].TST_PubExponentSize,
					SEP_RSA_Acceptance_ExtHashSignVerify_TestData[TST_index].TST_PrivetExponent_D,
					SEP_RSA_Acceptance_ExtHashSignVerify_TestData[TST_index].TST_KeySize,
					SEP_RSA_Acceptance_ExtHashSignVerify_TestData[TST_index].TST_Modulus_N,
					SEP_RSA_Acceptance_ExtHashSignVerify_TestData[TST_index].TST_KeySize,
					TST_CRT_Mode,
					TST_KeyGenType,
					TST_HashType ,
					SEP_RSA_Acceptance_ExtHashSignVerify_TestData[TST_index].TST_P,
					SEP_RSA_Acceptance_ExtHashSignVerify_TestData[TST_index].TST_DPSize,
					SEP_RSA_Acceptance_ExtHashSignVerify_TestData[TST_index].TST_Q,                                                                                                
					SEP_RSA_Acceptance_ExtHashSignVerify_TestData[TST_index].TST_DPSize,
					SEP_RSA_Acceptance_ExtHashSignVerify_TestData[TST_index].TST_dP,                                                                                                   
					SEP_RSA_Acceptance_ExtHashSignVerify_TestData[TST_index].TST_DPSize,    
					SEP_RSA_Acceptance_ExtHashSignVerify_TestData[TST_index].TST_dQ,                                                                                                   
					SEP_RSA_Acceptance_ExtHashSignVerify_TestData[TST_index].TST_DPSize,                                                                                                   
					SEP_RSA_Acceptance_ExtHashSignVerify_TestData[TST_index].TST_Qinv,
					SEP_RSA_Acceptance_ExtHashSignVerify_TestData[TST_index].TST_DPSize,
					TST_DataIn,
					TST_DataInSize,
					FailureFunctionNameOut,
					FailureFunctionName_K_Size);

				TST_TestStatus = TST_ATP_CheckErrorReturn(TST_ATP_Error,"SEPQA_RSA_PKCS1v15_ExternalHash_SignVerify",FailureFunctionNameOut,TST_MasterTestName);                   

				if (TST_TestStatus != TESTPASS) 
					goto End;		

			}/*End of TST_CRT_Mode loop*/
		}/*End of TST_HashType loop*/
	}/* End of TST_KeyGenType loop*/  
End:
	return TST_TestStatus;
}/*End of CRYS_Ext_ATP_RSA_Acceptance_PKCS1v15_ExternalHash_SignVerify*/
/*****************************************************/
/*TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************/
/*--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************/
/*TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************/
/*--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************/
/*****************************************************/


/***************************
 * Function Name:                                                           
 *  CRYS_Ext_ATP_RSA_PSS_ExternalHash_SignVerify         
 * 
 * Inputs:
 * 	TST_KeyGeneration_TestStatus - A parameter defining if to run the test with internal key generation 
 *                                TST_INTERNAL_KG - Run the test with internal key generation and external keys 
 *                                TST_EXTERNAL_KEYPAIR  - Run the test with external key only - NO keyGen
 *
 * Outputs:
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for RSA PKCS1v2.1 PSS Sign & Verify
 *  When the Hash for the Sign is preformed externally                   
 *  This function Signs & Verifies hash vectors using RSA PKCS1v2.1 PSS                                                   
 *  Key sizes used     (in bits) - 2048
 * Algorithm:       
 *   Algorithm:                       
 * 1. Call the SEPQA_RSA_PSS_ExternalHash_SignVerify function to execute test
 * 2. Verify function succeded according to the returned error code            
 *
 **************************/


CRYSError_t CRYS_Ext_ATP_RSA_PSS_ExternalHash_SignVerify (int TST_KeyGeneration_TestStatus)
{
	/*** TST Variables Definitions ****/
	int         TST_index = 0,TST_CRT_Mode;
	CRYSError_t TST_TestStatus=0;
	int         TST_KeyGenType;
	char        TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_Ext_ATP_RSA_PSS_ExternalHash_SignVerify";    
	int			TST_HashType;

	ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*********************** \n"));
	ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"** CRYS_Ext_ATP_RSA_PSS_ExternalHash_SignVerify       ** \n"));      
	ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*********************** \n \n"));

	/****************/
	/***** Start of test ********/
	/****************/
	/* Setting if to use internal key generation */
	if (TST_KeyGeneration_TestStatus == TST_NO_INTERNAL_KEYGEN)
		TST_KeyGenType = TST_EXTERNAL_KEYPAIR;
	else
		TST_KeyGenType = TST_INTERNAL_KG;

	for ( ; TST_KeyGenType <2 ; TST_KeyGenType++)/*TST_KeyGenType = 0 Internal KeyGen // TST_KeyGenType = 1 External keys*/
	{   
		for (TST_HashType = 0 ; TST_HashType < CRYS_HASH_NumOfModes ; TST_HashType++) 
		{
			if (TST_HashType != CRYS_HASH_MD5_mode) /* MD5 is not a part of the OAEP scheme*/
			{
				for (TST_CRT_Mode = 0 ; TST_CRT_Mode < 2 ; TST_CRT_Mode++)/* TST_CRT_Mode = 0 no CRT // TST_CRT_Mode = 1 CRT mode*/
				{   
					/* CRT constraint CRT with 512 key dose not work on other then SW platfrom*/
					if (((TST_CRT_Mode == TST_CRT_MODE) && 
						(SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize == TST_RSA_512_KEY_SIZE_IN_BYTES) &&
						((TST_ATP_CRYS_version.LLF_PKI_Version.type != CRYS_DEFS_SW_ENGINE_TYPE))))
						continue;
					/* SHA384 & SHA512 are not used with RSA 512bit keys*/
					if ((SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize == TST_RSA_512_KEY_SIZE_IN_BYTES)&&
						((TST_HashType == CRYS_HASH_SHA384_mode)||(TST_HashType == CRYS_HASH_SHA512_mode)))
						continue;      

					/* output buffer != input buffer    */
					ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"************************ \n"));
					ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," %s[test A.%d]\n",SEP_RSA_Acceptance_ExtHashSignVerify_TestData[TST_index].TST_Name,TST_index));  
					if (TST_CRT_Mode == TST_NO_CRT)
						ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," Non CRT mode  \n"));
					else
						ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," CRT mode  \n"));
					if (TST_KeyGenType == TST_INTERNAL_KG)
						ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," Internal Key Generation  \n"));
					else
						ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," External Keys  \n"));  
					CRYS_ATP_TST_PrintHASHType((CRYS_HASH_OperationMode_t)TST_HashType);
					ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"************************ \n")); 

				    TST_ATP_Error = SEPQA_RSA_PSS_ExternalHash_SignVerify(
						SEP_RSA_Acceptance_ExtHashSignVerify_TestData[TST_index].TST_PublicExponent_E,
						SEP_RSA_Acceptance_ExtHashSignVerify_TestData[TST_index].TST_PubExponentSize,
						SEP_RSA_Acceptance_ExtHashSignVerify_TestData[TST_index].TST_PrivetExponent_D,
						SEP_RSA_Acceptance_ExtHashSignVerify_TestData[TST_index].TST_KeySize,
						SEP_RSA_Acceptance_ExtHashSignVerify_TestData[TST_index].TST_Modulus_N,
						SEP_RSA_Acceptance_ExtHashSignVerify_TestData[TST_index].TST_KeySize,
						TST_CRT_Mode,
						TST_KeyGenType,
						TST_HashType,
						SEP_RSA_Acceptance_SignVerify_TestData[TST_index].TST_SaltLength,
						SEP_RSA_Acceptance_ExtHashSignVerify_TestData[TST_index].TST_P,
						SEP_RSA_Acceptance_ExtHashSignVerify_TestData[TST_index].TST_DPSize,
						SEP_RSA_Acceptance_ExtHashSignVerify_TestData[TST_index].TST_Q,                                                                                                
						SEP_RSA_Acceptance_ExtHashSignVerify_TestData[TST_index].TST_DPSize,
						SEP_RSA_Acceptance_ExtHashSignVerify_TestData[TST_index].TST_dP,                                                                                                   
						SEP_RSA_Acceptance_ExtHashSignVerify_TestData[TST_index].TST_DPSize,    
						SEP_RSA_Acceptance_ExtHashSignVerify_TestData[TST_index].TST_dQ,                                                                                                   
						SEP_RSA_Acceptance_ExtHashSignVerify_TestData[TST_index].TST_DPSize,                                                                                                   
						SEP_RSA_Acceptance_ExtHashSignVerify_TestData[TST_index].TST_Qinv,
						SEP_RSA_Acceptance_ExtHashSignVerify_TestData[TST_index].TST_DPSize,
						SEP_RSA_Acceptance_ExtHashSignVerify_TestData[TST_index].TST_input_hash_SHA1,
						CRYS_HASH_SHA1_DIGEST_SIZE_IN_BYTES,
						FailureFunctionNameOut,
						FailureFunctionName_K_Size);

					TST_TestStatus = TST_ATP_CheckErrorReturn(TST_ATP_Error,"SEPQA_RSA_OAEP_EncDec",FailureFunctionNameOut,TST_MasterTestName);                   

					if (TST_TestStatus != TESTPASS) 
						goto End;				
				}/*End of TST_CRT_Mode loop*/
			}/*End of MD5 if*/
		}/*End of Hash Type*/
	}/*End of TST_KeyGenType loop*/ 
End:
	return TST_TestStatus; 
}/*End of CRYS_ATP_TST_RSA_Acceptance_PSS_ExternalHash_SignVerify*/

/*****************************************************/
/*TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************/
/*--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************/
/*TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************/
/*--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************/
/*****************************************************/

/***************************
 * Function Name:                                                           
 *  CRYS_Ext_ATP_RSA_Get_PrivAndPubKey         
 * 
 * Inputs:
 * 	TST_KeyGeneration_TestStatus - A parameter defining if to run the test with internal key generation 
 *                                TST_INTERNAL_KG - Run the test with internal key generation and external keys 
 *                                TST_EXTERNAL_KEYPAIR  - Run the test with external key only - NO keyGen
 *
 * Outputs:
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for RSA PKCS1v2.1 PSS Sign & Verify
 *  When the Hash for the Sign is preformed externally                   
 *  This function Signs & Verifies hash vectors using RSA PKCS1v2.1 PSS                                                   
 *  Key sizes used     (in bits) - 2048
 * Algorithm:       
 *   Algorithm:                       
 * 1. Call the SEPQA_RSA_PSS_ExternalHash_SignVerify function to execute test
 * 2. Verify function succeded according to the returned error code            
 *
 **************************/
 
 CRYSError_t CRYS_Ext_ATP_RSA_Get_PrivAndPubKey(int TST_KeyGeneration_TestStatus)
{
	/*** TST Variables Definitions ****/
	int         TST_index = 0,TST_CRT_Mode;
	CRYSError_t TST_TestStatus=0;
	int         TST_KeyGenType;
	char        TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_Ext_ATP_RSA_Get_PrivAndPubKey"; 
	int 	    TST_HashType;
	CRYS_RSA_HASH_OpMode_t TST_RSAHashType=CRYS_RSA_HASH_NumOfModes;

	ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*********************** \n"));
	ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"** CRYS_Ext_ATP_RSA_Get_PrivAndPubKey    ** \n"));      
	ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*********************** \n \n"));

	/****************/
	/***** Start of test ********/
	/****************/
	/* Setting if to use internal key generation */

	if (TST_KeyGeneration_TestStatus == TST_NO_INTERNAL_KEYGEN)
		TST_KeyGenType = TST_EXTERNAL_KEYPAIR;
	else
		TST_KeyGenType = TST_INTERNAL_KG;

	for ( ; TST_KeyGenType <2 ; TST_KeyGenType++)/*TST_KeyGenType = 0 Internal KeyGen // TST_KeyGenType = 1 External keys*/
	{   
		for (TST_HashType = 0 ; TST_HashType < CRYS_HASH_NumOfModes ; TST_HashType++)
		{   
			switch(TST_HashType)
			{
			case CRYS_HASH_SHA1_mode:
				TST_RSAHashType = CRYS_RSA_HASH_SHA1_mode;
				break;
			case CRYS_HASH_SHA224_mode:
				TST_RSAHashType = CRYS_RSA_HASH_SHA224_mode;
				break;
			case CRYS_HASH_SHA256_mode:
				TST_RSAHashType = CRYS_RSA_HASH_SHA256_mode;
				break;
			case CRYS_HASH_SHA384_mode:
#ifndef LLF_HASH_SHA384_SHA512_NOT_SUPPORTED
				TST_RSAHashType = CRYS_RSA_HASH_SHA384_mode;
				break;
#else
				continue;
#endif
			case CRYS_HASH_SHA512_mode:
#ifndef LLF_HASH_SHA384_SHA512_NOT_SUPPORTED
				TST_RSAHashType = CRYS_RSA_HASH_SHA512_mode;
				break;
#else
				continue;
#endif
			default:
				break;
			}
			for (TST_CRT_Mode = 0 ; TST_CRT_Mode < 2 ; TST_CRT_Mode++)/* TST_CRT_Mode = 0 no CRT // TST_CRT_Mode = 1 CRT mode*/
			{   
				/* CRT constraint CRT with 512 key dose not work on other then SW platfrom*/
				if (((TST_CRT_Mode == TST_CRT_MODE) && 
					(SEP_RSA_Acceptance_ExportPrivAndPubKey_TestData[TST_index].TST_KeySize == TST_RSA_512_KEY_SIZE_IN_BYTES) &&
					((TST_ATP_CRYS_version.LLF_PKI_Version.type != CRYS_DEFS_SW_ENGINE_TYPE))))
					continue;
				/* SHA384 & SHA512 are not used with RSA 512bit keys*/
				if ((SEP_RSA_Acceptance_ExportPrivAndPubKey_TestData[TST_index].TST_KeySize == TST_RSA_512_KEY_SIZE_IN_BYTES)&&
					((TST_RSAHashType == CRYS_RSA_HASH_SHA384_mode)||(TST_RSAHashType == CRYS_RSA_HASH_SHA512_mode)))
					continue;

				/* output buffer != input buffer    */
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"************************ \n"));
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," %s[test 5.%d]\n",SEP_RSA_Acceptance_ExportPrivAndPubKey_TestData[TST_index].TST_Name,TST_index)); 
				CRYS_ATP_TST_PrintHASHType((CRYS_HASH_OperationMode_t)TST_HashType);                
				if (TST_CRT_Mode == TST_NO_CRT)
					ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," Non CRT mode  \n"));
				else
					ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," CRT mode  \n"));
				if (TST_KeyGenType == TST_INTERNAL_KG)
					ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," Internal Key Generation  \n"));
				else
					ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," External Keys  \n"));                                
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"************************ \n"));


				/* Debug massages */
				ATP_LOG_TST_PRINT((CRYS_ATP_TST_DBG_HIGH,"Input Data Size [byte] = %1d \n" ,SEP_RSA_Acceptance_ExportPrivAndPubKey_TestData[TST_index].TST_input_dataSize));

				
					TST_ATP_Error = SEPQA_RSA_Get_PrivAndPubKey(
						SEP_RSA_Acceptance_ExportPrivAndPubKey_TestData[TST_index].TST_PublicExponent_E,
						SEP_RSA_Acceptance_ExportPrivAndPubKey_TestData[TST_index].TST_PubExponentSize,
						SEP_RSA_Acceptance_ExportPrivAndPubKey_TestData[TST_index].TST_PrivetExponent_D,
						SEP_RSA_Acceptance_ExportPrivAndPubKey_TestData[TST_index].TST_KeySize,
						SEP_RSA_Acceptance_ExportPrivAndPubKey_TestData[TST_index].TST_Modulus_N,
						SEP_RSA_Acceptance_ExportPrivAndPubKey_TestData[TST_index].TST_KeySize,
						TST_CRT_Mode,
						SEP_RSA_Acceptance_ExportPrivAndPubKey_TestData[TST_index].TST_P,
						SEP_RSA_Acceptance_ExportPrivAndPubKey_TestData[TST_index].TST_DPSize,
						SEP_RSA_Acceptance_ExportPrivAndPubKey_TestData[TST_index].TST_Q,                                                                                                 
						SEP_RSA_Acceptance_ExportPrivAndPubKey_TestData[TST_index].TST_DPSize,
						SEP_RSA_Acceptance_ExportPrivAndPubKey_TestData[TST_index].TST_dP,                                                                                                
						SEP_RSA_Acceptance_ExportPrivAndPubKey_TestData[TST_index].TST_DPSize, 
						SEP_RSA_Acceptance_ExportPrivAndPubKey_TestData[TST_index].TST_dQ,                                                                                                
						SEP_RSA_Acceptance_ExportPrivAndPubKey_TestData[TST_index].TST_DPSize,                                                                                                
						SEP_RSA_Acceptance_ExportPrivAndPubKey_TestData[TST_index].TST_Qinv,
						SEP_RSA_Acceptance_ExportPrivAndPubKey_TestData[TST_index].TST_DPSize,
						FailureFunctionNameOut,
						FailureFunctionName_K_Size);

					TST_TestStatus = TST_ATP_CheckErrorReturn(TST_ATP_Error,"SEPQA_RSA_Get_PrivAndPubKey",FailureFunctionNameOut,TST_MasterTestName);                   

					if (TST_TestStatus != TESTPASS) 
						goto End;                                 														
				}
		}/* End of TST_HashType loop*/
	}/* End of TST_KeyGenType loop*/
End:
	return TST_TestStatus; 
}/*End of SEPQA_RSA_Get_PrivAndPubKey*/
